/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAvoidHuorn;
import lotr.common.entity.ai.LOTREntityAIDrink;
import lotr.common.entity.ai.LOTREntityAIEat;
import lotr.common.entity.ai.LOTREntityAIHobbitChildFollowGoodPlayer;
import lotr.common.entity.ai.LOTREntityAIHobbitSmoke;
import lotr.common.entity.ai.LOTREntityAINPCAvoidEvilPlayer;
import lotr.common.entity.ai.LOTREntityAINPCFollowParent;
import lotr.common.entity.ai.LOTREntityAINPCFollowSpouse;
import lotr.common.entity.ai.LOTREntityAINPCMarry;
import lotr.common.entity.ai.LOTREntityAINPCMate;
import lotr.common.entity.npc.LOTREntityMan;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.entity.npc.LOTREntityRuffianBrute;
import lotr.common.entity.npc.LOTREntitySpiderBase;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.entity.npc.LOTREntityWarg;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.fac.LOTRFaction;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.world.biome.LOTRBiomeGenShire;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityHobbit
extends LOTREntityMan {
    public LOTREntityHobbit(World world) {
        super(world);
        this.func_70105_a(0.45f, 1.2f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityOrc.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityWarg.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityTroll.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntitySpiderBase.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityRuffianBrute.class, 8.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIAvoidHuorn(this, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.6));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAINPCAvoidEvilPlayer(this, 8.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new LOTREntityAIHobbitChildFollowGoodPlayer(this, 12.0f, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LOTREntityAINPCMarry(this, 1.3));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAINPCMate(this, 1.3));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new LOTREntityAINPCFollowParent(this, 1.4));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new LOTREntityAINPCFollowSpouse(this, 1.1));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.1));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new LOTREntityAIEat(this, this.getHobbitFoods(), 3000));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new LOTREntityAIDrink(this, this.getHobbitDrinks(), 3000));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new LOTREntityAIHobbitSmoke(this, 4000));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.familyInfo.marriageEntityClass = LOTREntityHobbit.class;
        this.familyInfo.marriageRing = LOTRMod.hobbitRing;
        this.familyInfo.marriageAlignmentRequired = 100.0f;
        this.familyInfo.marriageAchievement = LOTRAchievement.marryHobbit;
        this.familyInfo.potentialMaxChildren = 4;
        this.familyInfo.timeToMature = 48000;
        this.familyInfo.breedingDelay = 24000;
    }

    protected LOTRFoods getHobbitFoods() {
        return LOTRFoods.HOBBIT;
    }

    protected LOTRFoods getHobbitDrinks() {
        return LOTRFoods.HOBBIT_DRINK;
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(this.field_70146_Z.nextBoolean());
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getHobbitName(this.field_70146_Z, this.familyInfo.isMale()));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)MathHelper.func_76136_a((Random)this.field_70146_Z, (int)16, (int)18));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    protected void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.HOBBIT;
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    @Override
    public void changeNPCNameForMarriage(LOTREntityNPC spouse) {
        if (this.familyInfo.isMale()) {
            LOTRNames.changeHobbitSurnameForMarriage(this, (LOTREntityHobbit)spouse);
        } else if (spouse.familyInfo.isMale()) {
            LOTRNames.changeHobbitSurnameForMarriage((LOTREntityHobbit)spouse, this);
        }
    }

    @Override
    public void createNPCChildName(LOTREntityNPC maleParent, LOTREntityNPC femaleParent) {
        this.familyInfo.setName(LOTRNames.getHobbitChildNameForParent(this.field_70146_Z, this.familyInfo.isMale(), (LOTREntityHobbit)maleParent));
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (this.familyInfo.interact(entityplayer)) {
            return true;
        }
        return super.func_70085_c(entityplayer);
    }

    @Override
    public boolean speakTo(EntityPlayer entityplayer) {
        boolean flag = super.speakTo(entityplayer);
        if (flag && this.isDrunkard() && entityplayer.func_82165_m(Potion.field_76431_k.field_76415_H)) {
            LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.speakToDrunkard);
        }
        return flag;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killHobbit;
    }

    @Override
    public float getAlignmentBonus() {
        return 1.0f;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int bones = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(LOTRMod.hobbitBone, 1);
        }
        this.dropHobbitItems(flag, i);
    }

    protected void dropHobbitItems(boolean flag, int i) {
        if (this.field_70146_Z.nextInt(8) == 0) {
            this.dropChestContents(LOTRChestContents.HOBBIT_HOLE_STUDY, 1, 1 + i);
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.dropChestContents(LOTRChestContents.HOBBIT_HOLE_LARDER, 1, 2 + i);
        }
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 1 + this.field_70146_Z.nextInt(3);
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            return j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == this.field_70170_p.func_72807_a((int)i, (int)k).field_76752_A;
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenShire) {
            f += 20.0f;
        }
        return f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isDrunkard()) {
            return "hobbit/drunkard/neutral";
        }
        if (this.isFriendly(entityplayer)) {
            return this.func_70631_g_() ? "hobbit/child/friendly" : "hobbit/hobbit/friendly";
        }
        return this.func_70631_g_() ? "hobbit/child/hostile" : "hobbit/hobbit/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.HOBBIT.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.HOBBIT;
    }

    @Override
    public void onArtificalSpawn() {
        if (this.getClass() == this.familyInfo.marriageEntityClass && this.field_70146_Z.nextInt(10) == 0) {
            this.familyInfo.setChild();
        }
    }
}

